<?php
/*
Plugin Name: Elfsight Instagram Widget CC
Description: Embed Instagram Profile to Your Website
Plugin URI: https://elfsight.com/instagram-widget-instalink/wordpress/?utm_source=markets&utm_medium=codecanyon&utm_campaign=instagram-widget&utm_content=plugin-site
Version: 2.2.0
Author: Elfsight
Author URI: https://elfsight.com/?utm_source=markets&utm_medium=codecanyon&utm_campaign=instagram-widget&utm_content=plugins-list
*/

if (!defined('ABSPATH')) exit;


require_once('core/elfsight-plugin.php');
require_once('api/elfsight-api.php');
require_once('includes/api.php');

$elfsight_instagram_widget_config_path = plugin_dir_path(__FILE__) . 'config.json';
$elfsight_instagram_widget_config = json_decode(file_get_contents($elfsight_instagram_widget_config_path), true);

new ElfsightInstagramWidgetApi(
    array(
        'slug' => 'elfsight-instagram-widget',
        'plugin_file' => __FILE__,
        'cache_time' => 21600,
        'media_limit' => 100,
        'use' => array('throttle'),
        'throttle' => array(
            'calls' => 19,
            'time' => 660
        ),
        'editor_config' => &$elfsight_instagram_widget_config
    )
);

$elfsightInstagramWidget = new ElfsightInstagramWidgetPlugin(
    array(
        'name' => esc_html__('Instagram Widget'),
        'description' => esc_html__('Embed Instagram Profile to Your Website'),
        'slug' => 'elfsight-instagram-widget',
        'version' => '2.2.0',
        'text_domain' => 'elfsight-instagram-widget',
        'editor_settings' => $elfsight_instagram_widget_config['settings'],
        'editor_preferences' => $elfsight_instagram_widget_config['preferences'],
        'script_url' => plugins_url('assets/elfsight-instagram-widget.js', __FILE__),

        'plugin_name' => esc_html__('Elfsight Instagram Widget'),
        'plugin_file' => __FILE__,
        'plugin_slug' => plugin_basename(__FILE__),

        'vc_icon' => plugins_url('assets/img/vc-icon.png', __FILE__),

        'menu_icon' => plugins_url('assets/img/menu-icon.png', __FILE__),
        'update_url' => esc_url('https://a.elfsight.com/updates/v1/'),

        'preview_url' => plugins_url('preview/index.html', __FILE__),
        'observer_url' => plugins_url('preview/instagram-widget-observer.js', __FILE__),

        'product_url' => esc_url('https://codecanyon.net/item/instagram-widget-wordpress-plugin-for-instagram/11170758?ref=Elfsight'),
        'support_url' => esc_url('https://elfsight.ticksy.com/submit/#100003626'),
    )
);

add_shortcode('instalink', array($elfsightInstagramWidget, 'addShortcode'));

?>