<?php

namespace Elementor;

// Exit if accessed directly
if ( !defined( 'ABSPATH' ) ) {
	exit;
}

class Thim_Search_Room_Element extends Widget_Base {

	public function get_name() {
		return 'thim-search-room';
	}

	public function get_title() {
		return esc_html__( 'Thim: Search Room', 'sailing' );
	}

	public function get_icon() {
		return 'thim-widget-icon thim-widget-icon-courses-searching';
	}

	public function get_categories() {
		return [ 'thim-elements' ];
	}

	public function get_base() {
		return basename( __FILE__, '.php' );
	}

	protected function _register_controls() {
		$this->start_controls_section(
			'search_room_settings',
			[
				'label' => esc_html__( 'Search Room Settings', 'sailing' )
			]
		);

		$this->add_control(
			'style',
			[
				'label'   => esc_html__( 'Select Box Style Image', 'sailing' ),
				'type'    => Controls_Manager::SELECT,
				'options' => [
					'base'    => esc_attr__( 'Style Old', 'sailing' ),
					'default' => esc_attr__( 'Style New', 'sailing' )
				],
				'default' => 'base',
			]
		);

		$this->add_control(
			'title',
			[
				'label'       => esc_html__( 'Title', 'sailing' ),
				'type'        => Controls_Manager::TEXT,
				'placeholder' => esc_html__( 'Title', 'sailing' ),
				'default'     => 'Your Reservation',
				'condition'   => [
					'style' => [ 'base' ]
				]
			]
		);

		$this->add_control(
			'show_label',
			[
				'label'     => esc_html__( 'Show Label Input', 'sailing' ),
				'type'      => Controls_Manager::SWITCHER,
				'default'   => 'no',
				'condition' => [
					'style' => [ 'base' ]
				]
			]
		);

		$this->add_control(
			'background_color',
			[
				'label'     => esc_html__( 'Background Color', 'sailing' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '#2eb0d1',
				'condition' => [
					'style' => [ 'base' ]
				]
			]
		);

		$this->add_control(
			'background_image',
			[
				'label'     => esc_html__( 'Background Image', 'sailing' ),
				'type'      => Controls_Manager::MEDIA,
				'default'   => [
					'url' => Utils::get_placeholder_image_src(),
				],
				'condition' => [
					'style' => [ 'base' ]
				]
			]
		);

		$this->add_control(
			'show_child',
			[
				'label'     => esc_html__( 'Show Child', 'sailing' ),
				'type'      => Controls_Manager::SWITCHER,
				'default'   => 'no',
				'condition' => [
					'style' => [ 'default' ]
				]
			]
		);

		$this->end_controls_section();
	}

	protected function render() {
		$settings = $this->get_settings_for_display();

		// Map variables between Elementor and SiteOrigin
		$instance = array();

		$instance['style'] = $settings['style'];

		$instance = array(
			'title'            => $settings['title'],
			'show_label'       => $settings['show_label'],
			'background_color' => $settings['background_color'],
			'background_image' => $settings['background_image']['id'],
			'show_child'       => $settings['show_child']
		);

		thim_get_widget_template( $this->get_base(), array( 'instance' => $instance ), $settings['style'] );
	}

}

Plugin::instance()->widgets_manager->register_widget_type( new Thim_Search_Room_Element() );