<?php

thim_customizer()->add_section(
	array(
		'id'       => 'display_postpage',
		'title'    => 'Post & Page',
		'panel'    => 'general',
		'priority' => 4,
	)
);


thim_customizer()->add_field(
	array(
		'id'      => 'thim_archive_single_layout',
		'type'    => 'radio-image',
		'label'   => esc_html__( 'Single & Page Layout', 'sailing' ),
		'tooltip' => esc_html__( 'Single & Page layout setting.', 'sailing' ),
		'section' => 'display_postpage',
		'choices' => array(
			'full-content'  => TP_THEME_URI . 'assets/images/admin/layout/body-full.png',
			'sidebar-left'  => TP_THEME_URI . 'assets/images/admin/layout/sidebar-left.png',
			'sidebar-right' => TP_THEME_URI . 'assets/images/admin/layout/sidebar-right.png'
		),
		'default' => 'sidebar-right'
	)
);

thim_customizer()->add_field(
	array(
		'id'      => 'thim_archive_single_hide_title',
		'type'    => 'switch',
		'section' => 'display_postpage',
		'label'   => esc_html__( 'Hide Title', 'sailing' ),
		'tooltip' => esc_html__( 'Hide title setting.', 'sailing' ),
		'default' => false,
		'choices' => array(
			true  => esc_html__( 'On', 'sailing' ),
			false => esc_html__( 'Off', 'sailing' ),
		),
	)
);


thim_customizer()->add_field(
	array(
		'id'      => 'thim_archive_single_top_image',
		'type'    => 'upload',
		'label'   => esc_html__( 'Top Image', 'sailing' ),
		'tooltip' => esc_html__( 'Top image for page and post setting.', 'sailing' ),
		'section' => 'display_postpage',
		'js_vars' => array(
			array(
				'element'  => '.top_site_main',
				'function' => 'css',
				'property' => 'background-image',
			),
		),
		'default' => TP_THEME_URI . 'assets/images/bg-blog.jpg'
	)
);

thim_customizer()->add_field(
	array(
		'id'        => 'thim_archive_single_heading_bg_color',
		'type'      => 'color',
		'label'     => esc_html__( 'Background Heading Color', 'sailing' ),
		'tooltip'   => esc_html__( 'Setting heading background color post and page.', 'sailing' ),
		'section'   => 'display_postpage',
		'default'   => '#ffffff',
		'alpha'     => true,
		'transport' => 'postMessage',
		'js_vars'   => array(
			array(
				'element'  => '.top_site_main.images_parallax:before',
				'function' => 'css',
				'property' => 'background-color',
			),
		),
	)
);

thim_customizer()->add_field(
	array(
		'id'        => 'thim_archive_single_heading_text_color',
		'type'      => 'color',
		'label'     => esc_html__( 'Heading Color', 'sailing' ),
		'tooltip'   => esc_html__( 'Setting heading text color setting.', 'sailing' ),
		'section'   => 'display_postpage',
		'default'   => '#ffffff',
		'alpha'     => true,
		'transport' => 'postMessage',
		'js_vars'   => array(
			array(
				'element'  => '.top_site_main .page-title-wrapper .banner-wrapper .heading__secondary',
				'function' => 'css',
				'property' => 'color',
			),
		),
	)
);

thim_customizer()->add_field(
	array(
		'id'      => 'thim_archive_single_title',
		'type'    => 'text',
		'label'   => esc_html__( 'Custom Title', 'sailing' ),
		'tooltip' => esc_html__( 'Enter your custom tile page and post.', 'sailing' ),
		'section' => 'display_postpage',
		'default' => '',
	)
);

thim_customizer()->add_field(
	array(
		'id'      => 'thim_archive_single_sub_title',
		'type'    => 'text',
		'label'   => esc_html__( 'Custom Sub Title', 'sailing' ),
		'tooltip' => esc_html__( 'Enter your custom sub tile page and post.', 'sailing' ),
		'section' => 'display_postpage',
		'default' => '',
	)
);

thim_customizer()->add_field(
	array(
		'id'      => 'thim_single_show_category',
		'type'    => 'switch',
		'section' => 'display_postpage',
		'label'   => esc_html__( 'Show Category', 'sailing' ),
		'tooltip' => esc_html__( 'Show category setting.', 'sailing' ),
		'default' => true,
		'choices' => array(
			true  => esc_html__( 'On', 'sailing' ),
			false => esc_html__( 'Off', 'sailing' ),
		),
	)
);

thim_customizer()->add_field(
	array(
		'id'      => 'thim_single_show_date',
		'type'    => 'switch',
		'section' => 'display_postpage',
		'label'   => esc_html__( 'Show Date', 'sailing' ),
		'tooltip' => esc_html__( 'Show date setting.', 'sailing' ),
		'default' => true,
		'choices' => array(
			true  => esc_html__( 'On', 'sailing' ),
			false => esc_html__( 'Off', 'sailing' ),
		),
	)
);

thim_customizer()->add_field(
	array(
		'id'      => 'thim_single_show_author',
		'type'    => 'switch',
		'section' => 'display_postpage',
		'label'   => esc_html__( 'Show Author', 'sailing' ),
		'tooltip' => esc_html__( 'Show author setting.', 'sailing' ),
		'default' => true,
		'choices' => array(
			true  => esc_html__( 'On', 'sailing' ),
			false => esc_html__( 'Off', 'sailing' ),
		),
	)
);

thim_customizer()->add_field(
	array(
		'id'      => 'thim_single_show_comment',
		'type'    => 'switch',
		'section' => 'display_postpage',
		'label'   => esc_html__( 'Show Comment', 'sailing' ),
		'tooltip' => esc_html__( 'Show comment setting.', 'sailing' ),
		'default' => true,
		'choices' => array(
			true  => esc_html__( 'On', 'sailing' ),
			false => esc_html__( 'Off', 'sailing' ),
		),
	)
);