<?php
function thim_hex2rgb( $hex ) {
	$hex = str_replace( "#", "", $hex );
	if ( strlen( $hex ) == 3 ) {
		$r = hexdec( substr( $hex, 0, 1 ) . substr( $hex, 0, 1 ) );
		$g = hexdec( substr( $hex, 1, 1 ) . substr( $hex, 1, 1 ) );
		$b = hexdec( substr( $hex, 2, 1 ) . substr( $hex, 2, 1 ) );
	} else {
		$r = hexdec( substr( $hex, 0, 2 ) );
		$g = hexdec( substr( $hex, 2, 2 ) );
		$b = hexdec( substr( $hex, 4, 2 ) );
	}
	$rgb = array( $r, $g, $b );

	return $rgb; // returns an array with the rgb values
}

function thim_getExtraClass( $el_class ) {
	$output = '';
	if ( $el_class != '' ) {
		$output = " " . str_replace( ".", "", $el_class );
	}

	return $output;
}

function thim_getCSSAnimation( $css_animation ) {
	$output = '';
	if ( $css_animation != '' ) {
		$output = ' wpb_animate_when_almost_visible wpb_' . $css_animation;
	}

	return $output;
}

function thim_excerpt( $limit ) {
	$excerpt = explode( ' ', get_the_excerpt(), $limit );
	if ( count( $excerpt ) >= $limit ) {
		array_pop( $excerpt );
		$excerpt = implode( " ", $excerpt ) . '...';
	} else {
		$excerpt = implode( " ", $excerpt );
	}
	$excerpt = strip_tags( preg_replace( '`\[[^\]]*\]`', '', $excerpt ) );

	return '<p>' . $excerpt . '</p>';
}

/************ List Comment ***************/
if ( !function_exists( 'thim_comment' ) ) {
	function thim_comment( $comment, $args, $depth ) {
		$GLOBALS['comment'] = $comment;
		//extract( $args, EXTR_SKIP );
		if ( 'div' == $args['style'] ) {
			$tag       = 'div';
			$add_below = 'comment';
		} else {
			$tag       = 'li';
			$add_below = 'div-comment';
		}
		?>
		<<?php echo ent2ncr( $tag . ' ' ) ?><?php comment_class( 'description_comment' ) ?> id="comment-<?php comment_ID() ?>">
		<div class="wrapper-comment">
			<?php
			if ( $args['avatar_size'] != 0 ) {
				echo '<div class="avatar">';
				echo get_avatar( $comment, $args['avatar_size'] );
				echo '</div>';
			}
			?>
			<div class="comment-right">
				<?php if ( $comment->comment_approved == '0' ) : ?>
					<em class="comment-awaiting-moderation"><?php esc_html_e( 'Your comment is awaiting moderation.', 'sailing' ) ?></em>
				<?php endif; ?>

				<div class="comment-extra-info">
					<div
						class="author"><span class="author-name"><?php echo get_comment_author_link(); ?></span></div>
					<div class="date" itemprop="commentTime">
						<?php printf( get_comment_date(), get_comment_time() ) ?></div>
					<?php edit_comment_link( esc_html__( 'Edit', 'sailing' ), '', '' ); ?>

					<?php comment_reply_link( array_merge( $args, array(
						'reply_text' => esc_html__( 'Reply', 'sailing' ),
						'after'      => '',
						'depth'      => $depth,
						'max_depth'  => $args['max_depth']
					) ) ); ?>
				</div>

				<div class="content-comment">
					<?php comment_text() ?>
				</div>
			</div>
		</div>
		<?php
	}
}
/************end list comment************/
/********************************************************************
 * Get image attach
 ********************************************************************/

function thim_feature_image( $attachment_id, $width = null, $height = null, $alt = null, $title = null ) {

	$src   = wp_get_attachment_image_src( $attachment_id, 'full' );
	$style = '';
	if ( !$src ) {
		// Get demo image
		global $wpdb;
		$attachment_id = $wpdb->get_col(
			$wpdb->prepare(
				"SELECT p.ID FROM $wpdb->posts AS p INNER JOIN $wpdb->postmeta AS pm ON p.ID = pm.post_id
				WHERE 	pm.meta_key = %s
				AND 	pm.meta_value LIKE %s",
				'_wp_attached_file',
				'%demo_image.jpg'
			)
		);

		if ( empty( $attachment_id[0] ) ) {
			return;
		}

		$attachment_id = $attachment_id[0];
		$src           = wp_get_attachment_image_src( $attachment_id, 'full' );

	}

	if ( $width && $height ) {

		if ( $src[1] >= $width || $src[2] >= $height ) {

			$crop = ( $src[1] >= $width && $src[2] >= $height ) ? true : false;

			$src[0] = aq_resize( $src[0], $width, $height, $crop );

		}

		$style = ' width="' . $width . '" height="' . $height . '"';
	}

	if ( !$alt ) {
		$alt = get_the_title( $attachment_id );
	}

	if ( !$title ) {
		$title = get_the_title( $attachment_id );
	}

	return '<img src="' . esc_url( $src[0] ) . '" alt="' . esc_attr( $alt ) . '" title="' . esc_attr( $title ) . '" ' . $style . '>';

}

#remove field in Display settings
require TP_THEME_DIR . 'inc/wrapper-before-after.php';

add_filter( 'thim_mtb_setting_after_created', 'thim_mtb_setting_after_created', 10, 2 );
function thim_mtb_setting_after_created( $mtb_setting ) {
	$mtb_setting->removeOption( array( 6, 11 ) );

	$settings = array(
		'name' => esc_html__( 'No Padding Content', 'sailing' ),
		'id'   => 'mtb_no_padding',
		'type' => 'checkbox',
		'desc' => ' ',
	);

	$mtb_setting->insertOptionBefore( $settings, 15 );

	return $mtb_setting;
}

function thim_wp_new_excerpt( $text ) {
	if ( $text == '' ) {
		$text           = get_the_content( '' );
		$text           = strip_shortcodes( $text );
		$text           = apply_filters( 'the_content', $text );
		$text           = str_replace( ']]>', ']]>', $text );
		$text           = strip_tags( $text );
		$text           = nl2br( $text );
		$excerpt_length = apply_filters( 'excerpt_length', 55 );
		$words          = explode( ' ', $text, $excerpt_length + 1 );
		if ( count( $words ) > $excerpt_length ) {
			array_pop( $words );
			array_push( $words, '' );
			$text = implode( ' ', $words );
		}
	}

	return $text;
}

remove_filter( 'get_the_excerpt', 'wp_trim_excerpt' );
add_filter( 'get_the_excerpt', 'thim_wp_new_excerpt' );

function thim_post_share() {

	if ( ( get_theme_mod( 'thim_archive_sharing_facebook' ) == 1 ) ||
		( get_theme_mod( 'thim_archive_sharing_twitter' ) == 1 ) ||
		( get_theme_mod( 'thim_archive_sharing_pinterest' ) ) == 1 ||
		( get_theme_mod( 'thim_archive_sharing_google' ) ) == 1
	) {
		echo '<ul class="social-share">';
		if ( get_theme_mod( 'thim_archive_sharing_facebook' ) == 1 ) {
			//echo '<li><a target="_blank" class="facebook" href="' . esc_url( 'https://www.facebook.com/sharer.php?s=100&amp;p[title]=' . get_the_title() . '&amp;p[url]=' . urlencode( get_permalink() ) . '&amp;p[images][0]=' . urlencode( wp_get_attachment_url( get_post_thumbnail_id() ) ) ) . '" title="' . esc_html__( 'Facebook', 'sailing' ) . '"><i class="fa fa-facebook"></i></a></li>';
			echo '<li><a target="_blank" class="facebook"  href="https://www.facebook.com/sharer.php?u=' . urlencode( get_permalink() ) . '" title="' . esc_attr__( 'Facebook', 'sailing' ) . '"><i class="fa fa-facebook"></i></a></li>';
		}
		if ( get_theme_mod( 'thim_archive_sharing_twitter' ) == 1 ) {
			echo '<li><a target="_blank" class="twitter" href="' . esc_url( 'https://twitter.com/share?url=' . urlencode( get_permalink() ) . '&amp;text=' . esc_attr( get_the_title() ) ) . '" title="' . esc_html__( 'Twitter', 'sailing' ) . '"><i class="fa fa-twitter"></i></a></li>';
		}
		if ( get_theme_mod( 'thim_archive_sharing_google' ) == 1 ) {
			echo '<li><a target="_blank" class="googleplus" href="' . esc_url( 'https://plus.google.com/share?url=' . urlencode( get_permalink() ) . '&amp;title=' . esc_attr( get_the_title() ) ) . '" title="' . esc_html__( 'Google Plus', 'sailing' ) . '" onclick=\'javascript:window.open(this.href, "", "menubar=no,toolbar=no,resizable=yes,scrollbars=yes,height=600,width=600");return false;\'><i class="fa fa-google"></i></a></li>';
		}
		if ( get_theme_mod( 'thim_archive_sharing_pinterest' ) == 1 ) {
			echo '<li><a target="_blank" class="pinterest" href="' . esc_url( 'http://pinterest.com/pin/create/button/?url=' . urlencode( get_permalink() ) . '&amp;description=' . get_the_excerpt() . '&media=' . urlencode( wp_get_attachment_url( get_post_thumbnail_id() ) ) ) . '" onclick="window.open(this.href); return false;" title="' . esc_html__( 'Pinterest', 'sailing' ) . '"><i class="fa fa-pinterest"></i></a></li>';
		}

		echo '</ul>';
	}

}

add_action( 'thim_social_share', 'thim_post_share' );

add_filter( 'wp_nav_menu_args', 'thim_select_main_menu' );
function thim_select_main_menu( $args ) {
	global $post;
	if ( $post ) {
		if ( get_post_meta( $post->ID, 'thim_select_menu_one_page', true ) != 'default' && ( $args['theme_location'] == 'primary' ) ) {
			$menu         = get_post_meta( $post->ID, 'thim_select_menu_one_page', true );
			$args['menu'] = $menu;
		}
	}

	return $args;
}

add_filter( 'wpcf7_support_html5_fallback', '__return_true' );

/**
 * Get google font
 *
 * @param $query
 *
 * @return string
 */
function thim_google_font_family( $query ) {
	$font_url = add_query_arg( 'family', urlencode( $query ), "//fonts.googleapis.com/css" );

	return $font_url;
}


function thim_ssl_secure_url( $sources ) {
	$scheme = parse_url( site_url(), PHP_URL_SCHEME );
	if ( 'https' == $scheme ) {
		if ( stripos( $sources, 'http://' ) === 0 ) {
			$sources = 'https' . substr( $sources, 4 );
		}

		return $sources;
	}

	return $sources;
}

function thim_ssl_secure_image_srcset( $sources ) {
	$scheme = parse_url( site_url(), PHP_URL_SCHEME );
	if ( 'https' == $scheme ) {
		foreach ( $sources as &$source ) {
			if ( stripos( $source['url'], 'http://' ) === 0 ) {
				$source['url'] = 'https' . substr( $source['url'], 4 );
			}
		}

		return $sources;
	}

	return $sources;
}

add_filter( 'wp_calculate_image_srcset', 'thim_ssl_secure_image_srcset' );
add_filter( 'wp_get_attachment_url', 'thim_ssl_secure_url', 1000 );
add_filter( 'image_widget_image_url', 'thim_ssl_secure_url' );


/**
 * Change default comment fields
 *
 * @param $field
 *
 * @return string
 */
function thim_new_comment_fields( $fields ) {
	$commenter = wp_get_current_commenter();
	$req       = get_option( 'require_name_email' );
	$aria_req  = ( $req ? 'aria-required=true' : '' );

	$fields = array(
		'author' => '<p class="comment-form-author">' . '<input placeholder="' . esc_attr__( 'Name', 'sailing' ) . ( $req ? ' *' : '' ) . '" id="author" name="author" type="text" value="' . esc_attr( $commenter['comment_author'] ) . '" size="30" ' . $aria_req . ' /></p>',
		'email'  => '<p class="comment-form-email">' . '<input placeholder="' . esc_attr__( 'Email', 'sailing' ) . ( $req ? ' *' : '' ) . '" id="email" name="email" type="text" value="' . esc_attr( $commenter['comment_author_email'] ) . '" size="30" ' . $aria_req . ' /></p>',
		'url'    => '<p class="comment-form-url">' . '<input placeholder="' . esc_attr__( 'Website', 'sailing' ) . '" id="url" name="url" type="text" value="' . esc_attr( $commenter['comment_author_url'] ) . '" size="30" /></p>',
	);

	return $fields;
}

add_filter( 'comment_form_default_fields', 'thim_new_comment_fields', 1 );


// Custom loading image for contact form 7
add_filter( 'wpcf7_ajax_loader', 'thim_wpcf7_ajax_loader' );
function thim_wpcf7_ajax_loader() {
	return TP_THEME_URI . 'assets/images/loading.gif';
}

/**
 * Add google analytics & facebook pixel code
 */
if ( !function_exists( 'thim_add_marketing_code' ) ) {
	function thim_add_marketing_code() {
		if ( get_theme_mod( 'thim_google_analytics' ) ) {
			?>
			<script>
				(function (i, s, o, g, r, a, m) {
					i['GoogleAnalyticsObject'] = r;
					i[r] = i[r] || function () {
						(i[r].q = i[r].q || []).push(arguments)
					}, i[r].l = 1 * new Date();
					a = s.createElement(o),
						m = s.getElementsByTagName(o)[0];
					a.async = 1;
					a.src = g;
					m.parentNode.insertBefore(a, m)
				})(window, document, 'script', 'https://www.google-analytics.com/analytics.js', 'ga');

				ga('create', '<?php echo get_theme_mod( 'thim_google_analytics' ); ?>', 'auto');
				ga('send', 'pageview');
			</script>
			<?php
		}
	}
}
add_action( 'wp_footer', 'thim_add_marketing_code' );

/**
 * Check a plugin active
 *
 * @param $plugin_dir
 * @param $plugin_file
 *
 * @return bool
 */
function thim_plugin_active( $plugin_dir, $plugin_file = null ) {
	$plugin_file            = $plugin_file ? $plugin_file : ( $plugin_dir . '.php' );
	$plugin                 = $plugin_dir . '/' . $plugin_file;
	$active_plugins_network = get_site_option( 'active_sitewide_plugins' );

	if ( isset( $active_plugins_network[$plugin] ) ) {
		return true;
	}

	$active_plugins = get_option( 'active_plugins' );

	if ( in_array( $plugin, $active_plugins ) ) {
		return true;
	}

	return false;
}

//pannel Widget Group
function thim_widget_group( $tabs ) {
	$tabs[] = array(
		'title'  => esc_html__( 'Thim Widget', 'sailing' ),
		'filter' => array(
			'groups' => array( 'thim_widget_group' )
		)
	);

	return $tabs;
}

add_filter( 'siteorigin_panels_widget_dialog_tabs', 'thim_widget_group', 19 );

//remove
function thim_row_style_fields( $fields ) {
	$fields['parallax'] = array(
		'name'        => esc_html__( 'Parallax', 'sailing' ),
		'type'        => 'checkbox',
		'group'       => 'design',
		'description' => esc_html__( 'If enabled, the background image will have a parallax effect.', 'sailing' ),
		'priority'    => 8,
	);

	return $fields;
}

add_filter( 'siteorigin_panels_row_style_fields', 'thim_row_style_fields' );

function thim_row_style_attributes( $attributes, $args ) {
	if ( !empty( $args['parallax'] ) ) {
		array_push( $attributes['class'], 'article__parallax' );
	}

	if ( !empty( $args['row_stretch'] ) && $args['row_stretch'] == 'full-stretched' ) {
		array_push( $attributes['class'], 'thim-fix-stretched' );
	}

	return $attributes;
}

add_filter( 'siteorigin_panels_row_style_attributes', 'thim_row_style_attributes', 10, 2 );


add_action( 'init', 'thim_add_excerpts_to_pages' );
function thim_add_excerpts_to_pages() {
	add_post_type_support( 'page', 'excerpt' );
}

add_action( 'hotel_booking_before_single_room_infomation', 'thim_hb_single_share' );
function thim_hb_single_share() {
	$html = '';
	if ( get_theme_mod( 'thim_hb_share_facebook' ) == 1 ||
		get_theme_mod( 'thim_hb_share_twitter' ) == 1 ||
		get_theme_mod( 'thim_hb_share_pinterest' ) == 1 ||
		get_theme_mod( 'thim_hb_share_google' ) == 1
	) {
		$html .= '<div class="hb-share">';
		$html .= '<ul class="share_show">';
		if ( get_theme_mod( 'thim_hb_share_facebook' ) == 1 ) {
			$html .= '<li><a target="_blank" class="facebook" href="' . esc_url( 'https://www.facebook.com/sharer.php?u=' . urlencode( get_permalink() ) ) . '&amp;t=' . esc_attr( get_the_title() ) . '" title="' . esc_html__( 'Facebook', 'sailing' ) . '"><i class="fa fa-facebook"></i></a></li>';
		}
		if ( get_theme_mod( 'thim_hb_share_twitter' ) == 1 ) {
			$html .= '<li><a target="_blank" class="twitter" href="' . esc_url( 'https://twitter.com/share?url=' . urlencode( get_permalink() ) . '&amp;text=' . esc_attr( get_the_title() ) ) . '" title="' . esc_html__( 'Twitter', 'sailing' ) . '"><i class="fa fa-twitter"></i></a></li>';
		}
		if ( get_theme_mod( 'thim_hb_share_pinterest' ) == 1 ) {
			$html .= '<li><a target="_blank" class="pinterest" href="' . esc_url( 'http://pinterest.com/pin/create/button/?url=' . urlencode( get_permalink() ) . '&amp;description=' . get_the_excerpt() . '&media=' . urlencode( wp_get_attachment_url( get_post_thumbnail_id() ) ) ) . '" onclick="window.open(this.href); return false;" title="' . esc_html__( 'Pinterest', 'sailing' ) . '"><i class="fa fa-pinterest"></i></a></li>';
		}
		if ( get_theme_mod( 'thim_hb_share_google' ) == 1 ) {
			$html .= '<li><a target="_blank" class="googleplus" href="' . esc_url( 'https://plus.google.com/share?url=' . urlencode( get_permalink() ) . '&amp;title=' . esc_attr( get_the_title() ) ) . '" title="' . esc_html__( 'Google Plus', 'sailing' ) . '" onclick=\'javascript:window.open(this.href, "", "menubar=no,toolbar=no,resizable=yes,scrollbars=yes,height=600,width=600");return false;\'><i class="fa fa-google"></i></a></li>';
		}
		$html .= '</ul>';
		$html .= '</div>';
	}
	echo ent2ncr( $html );
}

//over thank you
add_action( 'template_include', 'thim_wphb_booking_received_template' );

if ( !function_exists( 'thim_wphb_booking_received_template' ) ) {
	function thim_wphb_booking_received_template( $template ) {

		if ( false !== get_query_var( 'thank-you', false ) ) {
			return TP_THEME_DIR . '/wp-hotel-booking/checkout/thank-you.php';
		}

		return $template;
	}
}

add_filter( 'hotel_booking_add_to_cart_results', 'thim_filter_callback_hotel_booking_add_to_cart_results', 10, 2 );
function thim_filter_callback_hotel_booking_add_to_cart_results( $results, $room ) {
	$results['name'] = sprintf( '%s', $room->name );

	return $results;
}

/**
 * Show room type
 *
 * @return string
 */
add_action( 'hotel_booking_loop_room_title', 'thim_bh_show_room_types' );
function thim_bh_show_room_types() {
	the_terms( get_the_ID(), 'hb_room_type', '<div class="room-types">', '<span class="sep"></span>', '</div>' );
}

/**
 * Waring do not re-activate Thim Framework.
 */
function thim_notify_do_not_re_active_thim_framework() {
	if ( class_exists( 'Thim_Notification' ) ) {
		$detect_upgraded = get_option( 'thim_auto_updated_theme_mods_20', false );

		if ( !$detect_upgraded ) {
			return;
		}

		$link_delete = network_admin_url( 'plugins.php?plugin_status=inactive' );

		Thim_Notification::add_notification(
			array(
				'id'          => 'do_not_support_thim_framework',
				'type'        => 'warning',
				'content'     => sprintf( __( 'Thim Core plugin is the newest upgrade version of Thim Framework. <strong>Do not re-activate Thim Framework and <a href="%s" title="Delete Thim Framework plugin">better delete this plugin</a></strong>.', 'sailing' ), $link_delete ),
				'dismissible' => true,
				'global'      => true,
			)
		);
	}
}

add_action( 'admin_init', 'thim_notify_do_not_re_active_thim_framework' );

add_action( 'init', 'thim_add_excerpts_to_room' );
function thim_add_excerpts_to_room() {
	add_post_type_support( 'hb_room', 'excerpt' );
}

//Filter image all-demo tp-chameleon
if ( !function_exists( 'thim_override_demo_image_tp_chameleon' ) ) {
	function thim_override_demo_image_tp_chameleon() {
		return TP_THEME_URI . 'assets/images/all-demo-sailing.png';
	}
}
add_filter( 'tp_chameleon_get_image_sprite_demos', 'thim_override_demo_image_tp_chameleon' );

/**
 * Filter demos path
 */
function thim_filter_site_demos( $demo_datas ) {
	$demo_data_file_path = get_template_directory() . '/inc/data/demos.php';
	if ( is_file( $demo_data_file_path ) ) {
		require $demo_data_file_path;
	}

	return $demo_datas;
}

add_filter( 'tp_chameleon_get_site_demos', 'thim_filter_site_demos' );

/**
 * @param $id
 * @param $size
 * @param $type : default is post
 *
 * @return string
 */
if ( !function_exists( 'thim_get_thumbnail' ) ) {
	function thim_get_thumbnail( $id, $size = 'thumbnail', $type = 'post', $link = true, $classes = '' ) {
		$width         = 0;
		$height        = 0;
		$attachment_id = $id;

		if ( $type === 'post' ) {
			$attachment_id = get_post_thumbnail_id( $id );
		}
		$src = wp_get_attachment_image_src( $attachment_id, 'full' );

		if ( $size != 'full' && !in_array( $size, get_intermediate_image_sizes() ) ) {
			//custom size
			$thumbnail_size = explode( 'x', $size );
			$width          = $thumbnail_size[0];
			$height         = $thumbnail_size[1];
			$img_src        = thim_aq_resize( $src[0], $width, $height, true );
		} else {
			if ( $size == 'full' ) {
				$img_src = $src[0];
				$width   = $src[1];
				$height  = $src[2];
			} else {
				$image_size = wp_get_attachment_image_src( $attachment_id, $size );
				$width      = $image_size[1];
				$height     = $image_size[2];
			}
		}

		if ( empty( $img_src ) ) {
			$img_src = $src[0];
		}

		$html = '';
		if ( $link ) {
			$html .= '<a href="' . esc_url( get_permalink( $id ) ) . '" class="img-link" target="_self">';
		}
		$html .= '<img ' . image_hwstring( $width, $height ) . ' src="' . esc_attr( $img_src ) . '" alt="' . get_the_title( $id ) . '" class="' . $classes . '">';
		if ( $link ) {
			$html .= '</a>';
		}

		return $html;
	}
}

/**
 * @param      $id
 * @param      $size
 */
if ( !function_exists( 'thim_thumbnail' ) ) {
	function thim_thumbnail( $id, $size, $type = 'post', $link = true, $classes = '' ) {
		echo thim_get_thumbnail( $id, $size, $type, $link, $classes );
	}
}

/**
 * Add button on single room
 *
 * @return string
 */
function thim_single_add_button() {
	if ( is_singular( 'hb_room' ) ) {
		if ( class_exists( 'WP_Hotel_Booking' ) ) {
			get_template_part( 'wp-hotel-booking-room/single-search', 'button' );
		} else {
			get_template_part( 'tp-hotel-booking-room/single-search', 'button' );
		}
	}
}

add_action( 'thim_sidebar_before', 'thim_single_add_button', 10 );

if ( class_exists( 'WP_Hotel_Booking_Room' ) ) {
	remove_action( 'hotel_booking_single_room_title', array(
		WP_Hotel_Booking_Room()->booking,
		'single_add_button'
	), 9 );
}

if ( class_exists( 'TP_Hotel_Booking_Room' ) ) {
	remove_action( 'hotel_booking_single_room_title', array(
		TP_Hotel_Booking_Room()->booking,
		'single_add_button'
	), 9 );
}

// remove <br> tags from text widget content, from 4.8 version WP adds these tags
remove_filter('widget_text_content', 'wpautop');

/**
 * Check import demo data page-builder
 */
add_action( 'wp_ajax_thim_update_theme_mods', 'thim_import_demo_page_builder' );
if ( ! function_exists( 'thim_import_demo_page_builder' ) ) {
	function thim_import_demo_page_builder() {
		$thim_key   = sanitize_text_field( $_POST["thim_key"] );
		$thim_value = sanitize_text_field( $_POST["thim_value"] );
		if ( ! is_multisite() ) {
			$active_plugins = get_option( 'active_plugins' );

			if ( $thim_value == 'visual_composer' ) {
				if ( ( $key = array_search( 'siteorigin-panels/siteorigin-panels.php', $active_plugins ) ) !== false ) {
					unset( $active_plugins[ $key ] );
				}
				if ( ( $key = array_search( 'elementor/elementor.php', $active_plugins ) ) !== false ) {
					unset( $active_plugins[ $key ] );
				}
				if ( ( $key = array_search( 'anywhere-elementor/anywhere-elementor.php', $active_plugins ) ) !== false ) {
					unset( $active_plugins[ $key ] );
				}

			} else if ( $thim_value == 'site_origin' ) {
				if ( ( $key = array_search( 'elementor/elementor.php', $active_plugins ) ) !== false ) {
					unset( $active_plugins[ $key ] );
				}
				if ( ( $key = array_search( 'anywhere-elementor/anywhere-elementor.php', $active_plugins ) ) !== false ) {
					unset( $active_plugins[ $key ] );
				}
				if ( ! in_array( 'siteorigin-panels/siteorigin-panels.php', $active_plugins ) ) {
					$active_plugins[] = 'siteorigin-panels/siteorigin-panels.php';
				}

			} else if ( $thim_value == 'elementor' ) {
				if ( ( $key = array_search( 'siteorigin-panels/siteorigin-panels.php', $active_plugins ) ) !== false ) {
					unset( $active_plugins[ $key ] );
				}
				if ( ! in_array( 'elementor/elementor.php', $active_plugins ) ) {
					$active_plugins[] = 'elementor/elementor.php';
				}
				if ( ! in_array( 'anywhere-elementor/anywhere-elementor.php', $active_plugins ) ) {
					$active_plugins[] = 'anywhere-elementor/anywhere-elementor.php';
				}

			}
			update_option( 'active_plugins', $active_plugins );
		}

		if ( empty( $thim_key ) || empty( $thim_value ) ) {
			$output = 'update fail';
		} else {
			set_theme_mod( $thim_key, $thim_value );
			$output = 'update success';
		}

		echo ent2ncr( $output );
		die();
	}
}

/**
 * Get Event Upcoming
 */
//Filter post_status tp_event
if ( ! function_exists( 'thim_get_upcoming_events' ) ) {
	function thim_get_upcoming_events($limit = 1, $args = array())
	{
		if ( is_tax( 'tp_event_category' ) ) {
			$args = wp_parse_args(
				$args,
				array(
					'post_type'  => 'tp_event',
					'posts_per_page' => $limit,
					'meta_query' => array(
						array(
							'key'     => 'tp_event_status',
							'value'   => 'upcoming',
							'compare' => '=',
						),
					),
					'tax_query'  => array(
						array(
							'taxonomy' => 'tp_event_category',
							'field'    => 'slug',
							'terms'    => get_query_var( 'term' ),
						)
					),
				)
			);
		} else {
			$args = wp_parse_args(
				$args,
				array(
					'post_type'  => 'tp_event',
					'posts_per_page' => $limit,
					'meta_query' => array(
						array(
							'key'     => 'tp_event_status',
							'value'   => 'upcoming',
							'compare' => '=',
						),
					),
				)
			);
		}
		return new WP_Query( $args );
	}
}