<?php
$number_show = $instance['number_show'];

echo '<div class="thim_tours_slider">';

$surplus = count( $instance['tours'] );
if ( $surplus > $number_show ) {
	echo '<div class="navigation owl-buttons">';
	echo '<div class="prev"><span class="ion-ios-arrow-left"></span></div>';
	echo '<div class="next"><span class="ion-ios-arrow-right"></span></div>';
	echo '</div>';
}

echo '<ul class="owl-carousel">';
if ( $instance['tours'] ) {
	foreach ( $instance['tours'] as $tours ) {
		echo '<li>';

		if ( thim_plugin_active( 'elementor' ) ) {
			$img_url = $tours['image']['url'];
		} else {
			$src = wp_get_attachment_image_src( $tours['image'], 'full' );
			$img_url = $src['0'];
		}
		echo '<img src="' . $img_url . '" alt="' . get_the_title() . '">';

		echo '<div class="tour_price">';
		echo '<span class="price">';
		echo $tours['price'];
		echo '</span>';
		echo '<span class="unit">';
		echo esc_html__( 'per night', 'sailing' );
		echo '</span>';
		echo '</div>';

		echo '<div class="tour_content">';
		echo '<span class="tour_infosale">';
		echo $tours['info_sale'];
		echo '</span>';
		echo '<h3 class="tour_name">';
		echo '<a href="' . $tours['link'] . '" target="_self">';
		echo $tours['name'];
		echo '</a>';
		echo '</h3>';
		echo '</div>';

		echo '</li>';
	}
}
echo '</ul></div>';
?>

<script type="text/javascript">
	(function ($) {
		"use strict";
		$(document).ready(function () {
			var thimpress_tour_carousel = $('.thim_tours_slider ul');
			thimpress_tour_carousel.owlCarousel({
				nav               : false,
				dots              : false,
				loop              : true,
				items             : <?php echo esc_js( $number_show ); ?>,
				dotsSpeed         : 600,
				smartSpeed        : 600,
				autoplay          : true,
				autoplayHoverPause: true,
				margin            : 30,
				responsive        : {
					// breakpoint from 0 up
					0   : {
						items: 1
					},
					// breakpoint from 480 up
					480 : {
						items: 1
					},
					// breakpoint from 768 up
					768 : {
						items: 2
					},
					// breakpoint from 1024 up
					1024: {
						items: <?php echo esc_js( $number_show ); ?>
					}
				}
			});
			// next
			$('.thim_tours_slider .navigation .next').click(function () {
				thimpress_tour_carousel.trigger('next.owl.carousel');
			});
			// prev
			$('.thim_tours_slider .navigation .prev').click(function () {
				thimpress_tour_carousel.trigger('prev.owl.carousel');
			});
		});
	})(jQuery);
</script>
